@extends('layouts.app')

@section('title', 'Welcome')

@section('content')
<div class="welcome-banner">
    <div class="container">
        <h1>Welcome to VapeBay</h1>
        <p class="lead">Your premium destination for quality vaping products</p>
        <a href="#featured" class="btn btn-light btn-lg">Explore Products</a>
    </div>
</div>

<div class="container">
    <section id="featured" class="mb-5">
        <h2 class="text-center mb-4">Featured Products</h2>
        <div class="row">
            @for ($i = 1; $i <= 4; $i++)
                <div class="col-md-6 col-lg-3">
                    <div class="card product-card h-100">
                        <img src="/api/placeholder/300/200" class="card-img-top" alt="Product Image">
                        <div class="card-body">
                            <h5 class="card-title">Product {{ $i }}</h5>
                            <p class="card-text">This is a sample product description. Here you would describe the features of this product.</p>
                            <p class="card-text"><strong>${{ rand(20, 100) }}.99</strong></p>
                            <a href="#" class="btn btn-primary">View Details</a>
                        </div>
                    </div>
                </div>
            @endfor
        </div>
    </section>

    <section class="mb-5">
        <div class="row align-items-center">
            <div class="col-md-6">
                <h2>Why Choose VapeBay?</h2>
                <ul class="list-unstyled">
                    <li><i class="bi bi-check-circle"></i> Premium Quality Products</li>
                    <li><i class="bi bi-check-circle"></i> Fast & Reliable Shipping</li>
                    <li><i class="bi bi-check-circle"></i> Excellent Customer Support</li>
                    <li><i class="bi bi-check-circle"></i> Competitive Pricing</li>
                </ul>
                <p>At VapeBay, we are committed to providing the best vaping experience for our customers. Our products are carefully selected from top manufacturers to ensure quality and reliability.</p>
                <a href="{{ route('about') }}" class="btn btn-outline-primary">Learn More</a>
            </div>
            <div class="col-md-6">
                <img src="/api/placeholder/500/300" class="img-fluid rounded" alt="About VapeBay">
            </div>
        </div>
    </section>

    <section class="mb-5">
        <h2 class="text-center mb-4">Customer Reviews</h2>
        <div class="row">
            @for ($i = 1; $i <= 3; $i++)
                <div class="col-md-4">
                    <div class="card h-100">
                        <div class="card-body">
                            <div class="mb-2">
                                @for ($j = 1; $j <= 5; $j++)
                                    <span class="text-warning">★</span>
                                @endfor
                            </div>
                            <p class="card-text">"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed do eiusmod tempor incididunt ut labore et dolore magna aliqua."</p>
                            <footer class="blockquote-footer">Customer {{ $i }}</footer>
                        </div>
                    </div>
                </div>
            @endfor
        </div>
    </section>

    <section>
        <div class="p-5 bg-light rounded">
            <div class="row">
                <div class="col-md-8">
                    <h2>Subscribe to Our Newsletter</h2>
                    <p>Stay updated with our latest products and promotions.</p>
                </div>
                <div class="col-md-4">
                    <form method="POST" action="{{ route('newsletter.subscribe') }}">
                        @csrf
                        <div class="input-group mb-3">
                            <input type="email" class="form-control" name="email" placeholder="Your Email" aria-label="Email" aria-describedby="button-addon2" required>
                            <button class="btn btn-primary" type="submit" id="button-addon2">Subscribe</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </section>
</div>
@endsection